module('g_level', package.seeall);

local last_id = 0  -- init to zero
local id_list = {}
next_level = ""


-- uploads a new gameobject with desired id into the game
-- keeps track of the id's
-- returns the id added
function upload(name,layer)
    local id = last_id + 1
    last_id = id
    id_list[id] = name
    lua:gameobject_upload(name,layer,id)  --string,int,unsigned int
    return id
end

--finds with a name
-- returns id (int)
function find(name)
    local i = 1 --lua tables begin from 1
    while i <= last_id do
        if id_list[i] == name then
            return i --return id if found
        end
        i = i + 1
    end
    return nil
end

--clears the table of id's
function reset()
    id_list = {}
    next_level = ""
    
    --reset highlights
    require 'g_highlights'
    g_highlights.reset()    
    -- reset all extra stuffs
   lua:reset_all_extra_for_level_change()
end

--find next id
-- return the id which will come next
function next_id()
    local next = last_id + 1
    return next
end

--gives a valid id... 
function give_id()
    local id = last_id + 1
    last_id = id
    return id
end